import tkinter as tk

def update_label():
    entry_string = var.get()
    num_intervals = float(entry_string)
    balance = (1 + 1/num_intervals)**num_intervals
    message = balance
    lbl_3.configure(text=message)
   
    return

root = tk.Tk()
root.title('Compound Interest Calculator')
root.geometry('350x140')

frame = tk.Frame(root, bg='blue', bd=2)
frame.pack(padx=0, pady=4)

lbl_1 = tk.Label(frame, text='Number of Intervals:')
var = tk.StringVar()
ent = tk.Entry(frame, textvariable=var, justify=tk.CENTER)
lbl_2 = tk.Label(frame, text='Balance at End of the Year:')
lbl_3 = tk.Label(frame, text=' ', width=20, bg='white')
btn = tk.Button(root, text='Calculate', command=update_label)

lbl_1.pack(fill=tk.X)
ent.pack(fill=tk.X)
lbl_2.pack(fill=tk.X)
lbl_3.pack(fill=tk.X)
btn.pack()

root.mainloop()

